/*
オブジェクト名変更.jsx
Copyright (c) 2015 Toshiyuki Takahashi
Released under the MIT license
http://opensource.org/licenses/mit-license.php
http://www.graphicartsunit.com/
ver. 0.1.1
*/
(function() {

	var doc = app.activeDocument;
	var targetItems = doc.selection;

	var SCRIPT_TITLE = 'オブジェクト名変更';
	var SCRIPT_VERSION = '0.1.0';

	// Settings
	var settings = {
		'inputNameText' : 'object',
		'addSerialNum' : false,
		'startNumText' : 0,
		'addExtention' : false,
		'extensionText' : 'png'
	}

	// UI dialog
	function mainDialog() {
		this.init();
		return this;
	};
	mainDialog.prototype.init = function() {

		var unit = 20;
		var thisObj = this;
		thisObj.dlg = new Window('dialog', SCRIPT_TITLE + ' - ver.' + SCRIPT_VERSION);
		thisObj.dlg.margins = [unit * 1.5, unit * 1.5, unit * 1.5, unit * 1.5];

		// ------------
		thisObj.labels = thisObj.dlg.add('group', undefined);
		thisObj.labels.alignment = 'left';
		thisObj.labels.orientation = 'row';

		thisObj.nameLabel = thisObj.labels.add("statictext", undefined, "名称");
		thisObj.nameLabel.alignment = 'left';

		thisObj.inputNameText = thisObj.labels.add("edittext", undefined, settings.inputNameText);
		thisObj.inputNameText.minimumSize = [200, 10];

		// ------------
		thisObj.optionPanel = thisObj.dlg.add("panel", undefined, "追加：");
		thisObj.optionPanel.minimumSize = [300, unit];

		// ------------
		thisObj.serialNumGroup = thisObj.optionPanel.add('group', undefined);
		thisObj.serialNumGroup.margins = [unit/2, unit/2, unit/2, unit*0];
		thisObj.serialNumGroup.alignment = 'left';
		thisObj.serialNumGroup.orientation = 'row';

		thisObj.addSerialNum = thisObj.serialNumGroup.add("checkbox", undefined, "連番（開始番号）：");
		thisObj.addSerialNum.value = settings.addSerialNum;
		thisObj.startNumText = thisObj.serialNumGroup.add("edittext", undefined, settings.startNumText);
		thisObj.startNumText.minimumSize = [50, undefined];

		// ------------
		thisObj.extensionGroup = thisObj.optionPanel.add('group', undefined);
		thisObj.extensionGroup.margins = [unit/2, unit/4, unit/2, unit/2];
		thisObj.extensionGroup.alignment = 'left';
		thisObj.extensionGroup.orientation = 'row';

		thisObj.addExtention = thisObj.extensionGroup.add("checkbox", undefined, "拡張子：");
		thisObj.addExtention.value = settings.addExtention;
		thisObj.extensionText = thisObj.extensionGroup.add("edittext", undefined, settings.extensionText);
		thisObj.extensionText.minimumSize = [70, undefined];

		// ------------
		thisObj.buttonGroup = thisObj.dlg.add('group', undefined);
		thisObj.buttonGroup.margins = [unit, unit * 0, unit, unit * 0];
		thisObj.buttonGroup.alignment = 'center';
		thisObj.buttonGroup.orientation = 'row';

		thisObj.cancel = thisObj.buttonGroup.add('button', undefined, 'キャンセル', {name: 'cancel'});
		thisObj.ok = thisObj.buttonGroup.add('button', undefined, '実行', { name:'ok'});

		thisObj.ok.onClick = function() {
			settings.inputNameText = thisObj.inputNameText.text;
			settings.addSerialNum = thisObj.addSerialNum.value;
			settings.startNumText = Number(thisObj.startNumText.text);
			settings.addExtention = thisObj.addExtention.value;
			settings.extensionText = thisObj.extensionText.text;

			try {
				changeName();
				thisObj.closeDialog();
			} catch(e) {
				alert('エラーが発生して処理を実行できませんでした\nエラー内容：' + e);
			}
		}
		thisObj.cancel.onClick = function() {
			thisObj.closeDialog();
		}
	};
	mainDialog.prototype.showDialog = function() {
		this.dlg.show();
	};
	mainDialog.prototype.closeDialog = function() {
		this.dlg.close();
	};

	var dialog = new mainDialog();

	if (!doc) {
		alert('対象ドキュメントがありません');
	} else {
		dialog.showDialog();
	}

	// Change the Objects
	function changeName() {
		for (var i = 0; i < targetItems.length; i++) {
			targetItems[i].name = settings.inputNameText;
			if(settings.addSerialNum) targetItems[i].name += (i + settings.startNumText);
			if(settings.addExtention) targetItems[i].name += '.' + settings.extensionText;
		}
		app.redraw();
	}

}());